Scriptname JBulk_PlayerAlias extends ReferenceAlias


JBulk_MainQuest Property mainQuest Auto
Actor Property PlayerRef Auto
FormList Property JBulk_WeaponContainerList Auto
FormList Property JBulk_BulkEnchantTokenList Auto

String MENU_NAME = "Crafting Menu"

Auto State Waiting
	Event OnMenuOpen(String menuName)
		if(menuName == MENU_NAME)
			GotoState("Enchanting")
			mainQuest.WeaponContainer = Game.FindClosestReferenceOfAnyTypeInListFromRef(JBulk_WeaponContainerList, PlayerRef, 1024)
		endif
	EndEvent
EndState

State Enchanting
	Event OnMenuClose(String menuName)
		if(menuName == MENU_NAME)
			GotoState("Waiting")
		endif
	EndEvent
	
	Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer)
		mainQuest.OnItemAddedFunction(akBaseItem, aiItemCount)
	EndEvent
EndState

Function Maintenance()
	RegisterForMenu(MENU_NAME)
	mainQuest.Maintenance()
EndFunction

Event OnPlayerLoadGame()
	Maintenance()
EndEvent

Event OnInit()
	Maintenance()
	AddInventoryEventFilter(JBulk_BulkEnchantTokenList)
EndEvent
